# Classe contenant toutes les options de DreaMaker


class Options

  def initialize

    path_ini = ini_path

    @options = charger_options(path_ini)

    return @options

  end


  # Renvoie la valeur d'une option spcifique
  def [](param)
    return @options[param]
  end

  def []=(param, value)
    @options[param] = value
  end


  # Renvoie les valeurs des options en rapport avec le redimensionnement
  def resize_opt
    return resize(2)
  end

  def resize(mode=0)
    # On rcupre les valeurs des diffrents paramtres
    return params("resize", mode)
  end


  def params(cle, mode=0)
    liste = []
    options = @options.to_a
    for option in options
      if option[0].egal_court(cle)
        liste << option
      end
    end

    liste.sort!
    return liste if mode == 0
    return liste.chacun_nb_index(0) if mode == 1
    return liste.chacun_nb_index(1) if mode == 2
  end


  def params_value(cle)
    return params(cle, 2)
  end

  def charger_options(path, archive=false)

    if archive == false
      begin
        contenu = DA::file_read(path)
      rescue DAE_File_Open, DAE_File_Read => e
        puts e.message
        raise(DMKE_Ini_File.new(path))
      end
    else
      contenu = Archive::read(path)
    end



    reg = /([^=\n]*)=(.*)/
    liste = contenu.scan(reg)

    options = {}

    for couple in liste
      options.update({couple[0].strip => couple[1].strip})
    end

    
    verifier_chiffre(options)

    return options

  end




  # Vrifie les options et transforme en chiffres celles qui en sont
  def verifier_chiffre(options)
    for cle, value in options
      options[cle] = value.to_i if value.to_i.to_s == value
      options[cle] = value.to_f if value.to_f.to_s == value
      options[cle] = true if value == "true"
      options[cle] = false if value == "false"
    end
  end




  def ini_path
    return $e.dossier_local(F_OPTIONS)
  end

end